import QtQuick 2.0
import AdaptDemoSystem 1.0

Group {
    effectName: "Fog"
    id: fog

    name: "fog"
    enabled: sync(name+".ON")

    property string textureBG: "bgBall"
    property string textureScr: "fogScreen"
    property real fogStartZ: sync(name+".startZ")
    property real fogEndZ: sync(name+".endZ")
    property real fogBgMulZ: sync(name+".bgMulZ")

    Blit { textureRT: "fogScreen"; blitRT: 0}

    Texture { textureUnit: 0; textureRT: textureBG }
    Texture { textureUnit: 1; textureRT: textureScr }
    Texture { textureUnit: 2; textureRT: "mainDepth" }
    Shader { file: "fx/_SharedQML/fog" }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        drawBuffers: 1
        ShaderParam { paramName: "flip"; paramValue: 1.0 }
        blendMode: "off"
        ShaderParam { paramName: "fogStartZ"; paramValue: fogStartZ; }
        ShaderParam { paramName: "fogEndZ"; paramValue: fogEndZ; }
        ShaderParam { paramName: "fogBgMulZ"; paramValue: fogBgMulZ; }
    }
}

